whoaUnitFrames = {}
whoaUnitFrames.config = {
    classColorPlayer = true,   -- true or false
    classColorTarget = true,   -- true or false
    classColorFocus = true,    -- true or false
    classColorParty = true,    -- true or false
    largeAuraSize = 27,        -- Blizzard default value is 21
    smallAuraSize = 21,        -- Blizzard default value is 17
    thousandSeparators = true, -- true or false
    simpleHealth = true,       -- rounds healthpoints over 100.000 (200.000 to 200 k, 3.000.000 to 3 m)
}

whoaUnitFrames.config.phrases = {
    ["1000 separator"] = ".",
    ["Dead"] = "Dead",
    ["Ghost"] = "Ghost",
    ["Offline"] = "Offline",
    ["kilo"] = " k",  -- simpleHealth 1.000
    ["mega"] = " m",  -- simpleHealth 1.000.000
    ["giga"] = " g",  -- simpleHealth 1.000.000.000
}

---------------------------------------------------
-- CONFIGURATION -> config.lua
-- NOT HERE!
---------------------------------------------------
local config = whoaUnitFrames.config
local _, class = UnitClass("player")
local classcolor = RAID_CLASS_COLORS[select(2, UnitClass("player"))]
local color = nil
local fhp, php, thp = 0
local fm, pm, tm = 0
local fhpMax, phpMax, thpMax = 0
local fhpPercent, phpPercent, thpPercent = 0

---------------------------------------------------
-- DK RUNES
---------------------------------------------------
if class == "DEATHKNIGHT" then
    RuneButtonIndividual1:ClearAllPoints()
    RuneButtonIndividual1:SetPoint("TOPLEFT", PlayerFrameManaBar, "BOTTOMLEFT", -1, -5)
end

---------------------------------------------------
-- PARTY
---------------------------------------------------
local function whoa_partyColors()
    if not InCombatLockdown() then
        local partyMembers = GetNumPartyMembers()
        if partyMembers > 0 then
            for i = 1, partyMembers do
                color = RAID_CLASS_COLORS[select(2, UnitClass("party"..i))]
                if color then
                    _G["PartyMemberFrame"..i.."HealthBar"]:SetStatusBarColor(color.r, color.g, color.b)
                    _G["PartyMemberFrame"..i.."HealthBar"].lockColor = true
                end
            end    
        end
    end
end

---------------------------------------------------
-- PLAYERFRAME
---------------------------------------------------

local function whoa_playerFrame()
    if not UnitHasVehicleUI("player") then
	PlayerFrame:SetScale(1.2)
        PlayerName:SetWidth(0.01)
        PlayerFrameGroupIndicatorText:ClearAllPoints()
        PlayerFrameGroupIndicatorText:SetPoint("BOTTOMLEFT", PlayerFrame, "TOP", 0, -20)
        PlayerFrameGroupIndicatorLeft:Hide()
        PlayerFrameGroupIndicatorMiddle:Hide()
        PlayerFrameGroupIndicatorRight:Hide()
        PlayerFrameHealthBar:ClearAllPoints()
        PlayerFrameHealthBar:SetPoint("TOPLEFT", 106, -24)
        PlayerFrameHealthBar:SetHeight(18)
        if classcolor and config.classColorPlayer then
            PlayerFrameHealthBar:SetStatusBarColor(classcolor.r, classcolor.g, classcolor.b)
            PlayerFrameHealthBar.lockColor = true
        else
            color = FACTION_BAR_COLORS[8] -- 8 is exalted
            if color then
                PlayerFrameHealthBar:SetStatusBarColor(color.r, color.g, color.b)
                PlayerFrameHealthBar.lockColor = true
            end
        end
        PlayerFrameHealthBarText:ClearAllPoints()
        PlayerFrameHealthBarText:SetPoint("CENTER", PlayerFrameHealthBar, "CENTER", 0, 0)
        PlayerFrameManaBar:ClearAllPoints()
        PlayerFrameManaBar:SetPoint("TOPLEFT", 106, -45)
        PlayerFrameManaBar:SetHeight(17)
        PlayerFrameManaBarText:ClearAllPoints()
        PlayerFrameManaBarText:SetPoint("CENTER", PlayerFrameManaBar, "CENTER", 0, 0)
    else
        if config.classColorPlayer then
            color = FACTION_BAR_COLORS[8] -- 8 is exalted
            if color then
                PlayerFrameHealthBar:SetStatusBarColor(color.r, color.g, color.b)
                PlayerFrameHealthBar.lockColor = true
            end
        end
        PlayerFrameHealthBar:SetHeight(12)
        PlayerFrameManaBar:SetHeight(12)
    end
end
hooksecurefunc("PlayerFrame_UpdateArt", whoa_playerFrame)
hooksecurefunc("PlayerFrame_SequenceFinished", whoa_playerFrame)

---------------------------------------------------
-- TARGETFRAME
---------------------------------------------------
local function whoa_targetFrame()
TargetFrame:SetScale(1.2)
    TargetFrame.nameBackground:Hide()
    TargetFrame.deadText:ClearAllPoints()
    TargetFrame.deadText:SetPoint("CENTER", TargetFrameHealthBar, "CENTER", 0, 0)
    TargetFrameTextureFrameName:ClearAllPoints()
    TargetFrameTextureFrameName:SetPoint("BOTTOMRIGHT", TargetFrame, "TOP", 0, -20)
    TargetFrameHealthBar:ClearAllPoints()
    TargetFrameHealthBar:SetPoint("TOPLEFT", 5, -24)
    TargetFrameHealthBar:SetHeight(18)
    TargetFrameTextureFrameHealthBarText:ClearAllPoints()
    TargetFrameTextureFrameHealthBarText:SetPoint("CENTER", TargetFrameHealthBar, "CENTER", 0, 0)
    TargetFrameManaBar:ClearAllPoints()
    TargetFrameManaBar:SetPoint("TOPLEFT", 5, -45)
    TargetFrameManaBar:SetHeight(17)
    TargetFrameTextureFrameManaBarText:ClearAllPoints()
    TargetFrameTextureFrameManaBarText:SetPoint("CENTER", TargetFrameManaBar, "CENTER", 0, 0)
    TargetFrame.threatNumericIndicator:SetPoint("BOTTOM", PlayerFrame, "TOP", 75, -22)
end

local function whoa_targetChange()
    if UnitIsPlayer("target") and config.classColorTarget then
        color = RAID_CLASS_COLORS[select(2, UnitClass("target"))]
    else
        color = FACTION_BAR_COLORS[UnitReaction("target", "player")]
    end
    if ( not UnitPlayerControlled("target") and UnitIsTapped("target") and not UnitIsTappedByPlayer("target") and not UnitIsTappedByAllThreatList("target") ) then
        TargetFrameHealthBar:SetStatusBarColor(0.5, 0.5, 0.5)
    else
        if color then
            TargetFrameHealthBar:SetStatusBarColor(color.r, color.g, color.b)
            TargetFrameHealthBar.lockColor = true
        end
    end
end
hooksecurefunc("TargetFrame_CheckFaction", whoa_targetChange)

-- Code from Blizzards TargetFrame.lua
function whoa_targetUpdateAuraPositions(self, auraName, numAuras, numOppositeAuras, largeAuraList, updateFunc, maxRowWidth, offsetX)
    -- aura positioning constants
    local AURA_OFFSET_Y = 3;
    local LARGE_AURA_SIZE = config.largeAuraSize;
    local SMALL_AURA_SIZE = config.smallAuraSize;
--  local AURA_ROW_WIDTH = 122;
--  local NUM_TOT_AURA_ROWS = 3;
    local size;
    local offsetY = AURA_OFFSET_Y;
    local rowWidth = 0;
    local firstBuffOnRow = 1;
    for i=1, numAuras do
        if ( largeAuraList[i] ) then
            size = LARGE_AURA_SIZE;
            offsetY = AURA_OFFSET_Y + AURA_OFFSET_Y;
        else
            size = SMALL_AURA_SIZE;
        end
        if ( i == 1 ) then
            rowWidth = size;
            self.auraRows = self.auraRows + 1;
        else
            rowWidth = rowWidth + size + offsetX;
        end
        if ( rowWidth > maxRowWidth ) then
            updateFunc(self, auraName, i, numOppositeAuras, firstBuffOnRow, size, offsetX, offsetY);
            rowWidth = size;
            self.auraRows = self.auraRows + 1;
            firstBuffOnRow = i;
            offsetY = AURA_OFFSET_Y;
--          if ( self.auraRows > NUM_TOT_AURA_ROWS ) then
--              maxRowWidth = AURA_ROW_WIDTH;
--          end
        else
            updateFunc(self, auraName, i, numOppositeAuras, i - 1, size, offsetX, offsetY);
        end
    end
end
hooksecurefunc("TargetFrame_UpdateAuraPositions", whoa_targetUpdateAuraPositions)

---------------------------------------------------
-- FOCUSFRAME
---------------------------------------------------
local function whoa_focusFrame()
    FocusFrame.nameBackground:Hide()
    FocusFrame.deadText:ClearAllPoints()
    FocusFrame.deadText:SetPoint("CENTER", FocusFrameHealthBar, "CENTER", 0, 0)
    FocusFrameTextureFrameName:ClearAllPoints()
    FocusFrameHealthBar:ClearAllPoints()
    FocusFrameHealthBar:SetPoint("TOPLEFT", 5, -24)
    FocusFrameHealthBar:SetHeight(18)
    FocusFrameManaBar:ClearAllPoints()
    FocusFrameManaBar:SetPoint("TOPLEFT", 5, -45)
    FocusFrameManaBar:SetHeight(17)
    FocusFrame.threatNumericIndicator:SetWidth(0.01)
    FocusFrame.threatNumericIndicator.bg:Hide()
    FocusFrame.threatNumericIndicator.text:Hide()
end

local function whoa_focusChange()
    if UnitIsPlayer("focus") and config.classColorFocus then
        color = RAID_CLASS_COLORS[select(2, UnitClass("focus"))]
    else
        color = FACTION_BAR_COLORS[UnitReaction("focus", "player")]
    end
    if color then
        FocusFrameHealthBar:SetStatusBarColor(color.r, color.g, color.b)
        FocusFrameHealthBar.lockColor = true
    end
end

---------------------------------------------------
-- TEXTE
---------------------------------------------------
local fplayerpercent = CreateFrame("Frame", "whoaPlayerPercent", PlayerFrameHealthBar)
fplayerpercent:SetPoint("LEFT", PlayerFrameHealthBar, "LEFT", 0, 0)
fplayerpercent:SetWidth(40)
fplayerpercent:SetHeight(20)
fplayerpercent.text = fplayerpercent:CreateFontString("PlayerPercentText", "OVERLAY")
fplayerpercent.text:SetAllPoints(fplayerpercent)
fplayerpercent.text:SetFontObject(TextStatusBarText)
fplayerpercent.text:SetJustifyH("RIGHT")

local fplayerhealth = CreateFrame("Frame", "whoaPlayerHealth", PlayerFrameHealthBar)
fplayerhealth:SetPoint("RIGHT", PlayerFrameHealthBar, "RIGHT", -5, 0)
fplayerhealth:SetWidth(75)
fplayerhealth:SetHeight(20)
fplayerhealth.text = fplayerhealth:CreateFontString("PlayerHealthText", "OVERLAY")
fplayerhealth.text:SetAllPoints(fplayerhealth)
fplayerhealth.text:SetFontObject(TextStatusBarText)
fplayerhealth.text:SetJustifyH("RIGHT")

local fplayermana = CreateFrame("Frame", "whoaPlayerMana", PlayerFrameManaBar)
fplayermana:SetPoint("RIGHT", PlayerFrameManaBar, "RIGHT", -5, 0)
fplayermana:SetWidth(75)
fplayermana:SetHeight(20)
fplayermana.text = fplayermana:CreateFontString("PlayerManaText", "OVERLAY")
fplayermana.text:SetAllPoints(fplayermana)
fplayermana.text:SetFontObject(TextStatusBarText)
fplayermana.text:SetJustifyH("RIGHT")

local ftargetpercent = CreateFrame("Frame", "whoaTargetPercent", TargetFrameHealthBar)
ftargetpercent:SetPoint("LEFT", TargetFrameHealthBar, "LEFT", 0, 0)
ftargetpercent:SetWidth(40)
ftargetpercent:SetHeight(20)
ftargetpercent.text = ftargetpercent:CreateFontString("TargetPercentText", "OVERLAY")
ftargetpercent.text:SetAllPoints(ftargetpercent)
ftargetpercent.text:SetFontObject(TextStatusBarText)
ftargetpercent.text:SetJustifyH("RIGHT")

local ftargethealth = CreateFrame("Frame", "whoaTargetHealth", TargetFrameHealthBar)
ftargethealth:SetPoint("RIGHT", TargetFrameHealthBar, "RIGHT", -5, 0)
ftargethealth:SetWidth(75)
ftargethealth:SetHeight(20)
ftargethealth.text = ftargethealth:CreateFontString("TargetHealthText", "OVERLAY")
ftargethealth.text:SetAllPoints(ftargethealth)
ftargethealth.text:SetFontObject(TextStatusBarText)
ftargethealth.text:SetJustifyH("RIGHT")

local ftargetmana = CreateFrame("Frame", "whoaTargetMana", TargetFrameManaBar)
ftargetmana:SetPoint("RIGHT", TargetFrameManaBar, "RIGHT", -5, 0)
ftargetmana:SetWidth(75)
ftargetmana:SetHeight(20)
ftargetmana.text = ftargetmana:CreateFontString("TargetManaText", "OVERLAY")
ftargetmana.text:SetAllPoints(ftargetmana)
ftargetmana.text:SetFontObject(TextStatusBarText)
ftargetmana.text:SetJustifyH("RIGHT")

local ffocuspercent = CreateFrame("Frame", "whoaFocusPercent", FocusFrameHealthBar)
ffocuspercent:SetPoint("LEFT", FocusFrameHealthBar, "LEFT", -45, 0)
ffocuspercent:SetWidth(40)
ffocuspercent:SetHeight(20)
ffocuspercent.text = ffocuspercent:CreateFontString("FocusPercentText", "OVERLAY")
ffocuspercent.text:SetAllPoints(ffocuspercent)
ffocuspercent.text:SetFontObject(TextStatusBarText)
ffocuspercent.text:SetJustifyH("RIGHT")

local function whoa_round(n, dp)
    return math.floor((n * 10^dp) + .5) / (10^dp)
end

local function whoa_format(n)
    local strLen = strlen(n)
--  if config.simpleHealth and n > 999999999 then
    if config.simpleHealth and strLen > 9 then
        return whoa_round(n/1e9, 1)..config.phrases["giga"]
--  elseif config.simpleHealth and n > 999999 then
    elseif config.simpleHealth and strLen > 6 then
        return whoa_round(n/1e6, 1)..config.phrases["mega"]
--  elseif config.simpleHealth and strLen > 5 then -- no simpleHealth under 100.000
    elseif config.simpleHealth and n > 199999 then -- no simpleHealth under 199.999
        return whoa_round(n/1e3, 0)..config.phrases["kilo"]
    elseif config.thousandSeparators then
        local left, num, right = string.match(n, '^([^%d]*%d)(%d*)(.-)')
        return left..(num:reverse():gsub('(%d%d%d)', '%1'..config.phrases["1000 separator"]):reverse())..right
    else
        return n
    end
end

local function whoa_ufText()
    -- focus
    fhp = FocusFrameHealthBar:GetValue()
    if fhp > 0 then
        if UnitIsDeadOrGhost("focus") then
            ffocuspercent:Hide()
            if UnitIsGhost("focus") then
                FocusFrameTextureFrameHealthBarText:SetText(config.phrases["Ghost"])
            else
                FocusFrameTextureFrameHealthBarText:SetText(config.phrases["Dead"])
            end
        else
            FocusFrameTextureFrameHealthBarText:SetText(whoa_format(fhp))
            if GetCVarBool("statusTextPercentage") then
                _, fhpMax = FocusFrameHealthBar:GetMinMaxValues()
                fhpPercent = math.floor((fhp / fhpMax) * 100)
                ffocuspercent:Show()
                ffocuspercent.text:SetText(fhpPercent.."%")
            end
        end
    end
    FocusFrameTextureFrameHealthBarText:ClearAllPoints()
    FocusFrameTextureFrameHealthBarText:SetPoint("CENTER", FocusFrameHealthBar, "CENTER", 0, 0)
    fm = FocusFrameManaBar:GetValue()
    if fm > 0 then
        if UnitIsDeadOrGhost("focus") then
            FocusFrameTextureFrameManaBarText:SetText()
        else
            FocusFrameTextureFrameManaBarText:SetText(whoa_format(fm))
        end
    else
        FocusFrameTextureFrameManaBarText:SetText()
    end
    if not UnitIsConnected("focus") then
        FocusFrameTextureFrameManaBarText:SetText(config.phrases["Offline"])
    end
    FocusFrameTextureFrameManaBarText:ClearAllPoints()
    FocusFrameTextureFrameManaBarText:SetPoint("CENTER", FocusFrameManaBar, "CENTER", 0, 0)
    -- player
    php = PlayerFrameHealthBar:GetValue()
    if php > 0 then
        if UnitIsDeadOrGhost("player") then
            fplayerhealth:Hide()
            fplayerpercent:Hide()
            if UnitIsGhost("player") then
                PlayerFrameHealthBarText:SetText(config.phrases["Ghost"])
            else
                PlayerFrameHealthBarText:SetText(config.phrases["Dead"])
            end
        else
            PlayerFrameHealthBarText:SetText()
            fplayerhealth:Show()
            fplayerhealth.text:SetText(whoa_format(php))
            if GetCVarBool("statusTextPercentage") then
                _, phpMax = PlayerFrameHealthBar:GetMinMaxValues()
                phpPercent = math.floor((php / phpMax) * 100)
                fplayerpercent:Show()
                fplayerpercent.text:SetText(phpPercent.."%")
            end
        end
    else
        if UnitIsDeadOrGhost("player") then
            if UnitIsGhost("player") then
                PlayerFrameHealthBarText:SetText(config.phrases["Ghost"])
            else
                PlayerFrameHealthBarText:SetText(config.phrases["Dead"])
            end
        end
        fplayerpercent:Hide()
        fplayerhealth:Hide()
    end
    pm = PlayerFrameManaBar:GetValue()
    PlayerFrameManaBarText:SetText()
    if pm > 0 then
        if UnitIsDeadOrGhost("player") then
            fplayermana:Hide()
        else
            fplayermana:Show()
            fplayermana.text:SetText(whoa_format(pm))
        end
    else
        fplayermana:Hide()
    end
    -- target
    thp = TargetFrameHealthBar:GetValue()
    if thp > 0 then
        if UnitIsDeadOrGhost("target") then
            ftargethealth:Hide()
            ftargetpercent:Hide()
            if UnitIsGhost("target") then
                TargetFrameTextureFrameHealthBarText:SetText(config.phrases["Ghost"])
            else
                TargetFrameTextureFrameHealthBarText:SetText(config.phrases["Dead"])
            end
        else
            TargetFrameTextureFrameHealthBarText:SetText()
            ftargethealth:Show()
            ftargethealth.text:SetText(whoa_format(thp))
            if GetCVarBool("statusTextPercentage") then
                _, thpMax = TargetFrameHealthBar:GetMinMaxValues()
                thpPercent = math.floor((thp / thpMax) * 100)
                ftargetpercent:Show()
                ftargetpercent.text:SetText(thpPercent.."%")
            end
        end
    else
        ftargetpercent:Hide()
        ftargethealth:Hide()
    end
    tm = TargetFrameManaBar:GetValue()
    TargetFrameTextureFrameManaBarText:SetText()
    if tm > 0 then
        if UnitIsDeadOrGhost("target") then
            ftargetmana:Hide()
        else
            ftargetmana:Show()
            ftargetmana.text:SetText(whoa_format(tm))
        end
    else
        ftargetmana:Hide()
    end
    if not UnitIsConnected("target") then
        ftargetmana:Hide()
        TargetFrameTextureFrameManaBarText:SetText(config.phrases["Offline"])
    end
end
hooksecurefunc("TextStatusBar_Initialize", whoa_ufText)
hooksecurefunc("TextStatusBar_OnEvent", whoa_ufText)
hooksecurefunc("TextStatusBar_UpdateTextString", whoa_ufText)
hooksecurefunc("TextStatusBar_OnValueChanged", whoa_ufText)
hooksecurefunc("HideTextStatusBarText", whoa_ufText)

---------------------------------------------------
-- CVAR_UPDATES
---------------------------------------------------
local function whoa_cvarUpdate()
    if GetCVarBool("fullSizeFocusFrame") then
        FocusFrameTextureFrameName:SetPoint("BOTTOMRIGHT", FocusFrame, "TOP", 0, -20)
    else
        FocusFrameTextureFrameName:SetPoint("BOTTOMRIGHT", FocusFrame, "TOP", 10, -20)
    end
    if GetCVarBool("statusTextPercentage") then
        if GetCVarBool("playerStatusText") then
            fplayerpercent:Show()
            fplayerhealth:Show()
            fplayermana:Show()
        else
            fplayerpercent:Hide()
            fplayerhealth:Hide()
            fplayermana:Hide()
        end
        if GetCVarBool("targetStatusText") then
            ftargetpercent:Show()
            ftargethealth:Show()
            ftargetmana:Show()
            ffocuspercent:Show()
        else
            ftargetpercent:Hide()
            ftargethealth:Hide()
            ftargetmana:Hide()
            ffocuspercent:Hide()
        end
    else
        fplayerpercent:Hide()
        ftargetpercent:Hide()
        ffocuspercent:Hide()
        if GetCVarBool("playerStatusText") then
            fplayerhealth:Show()
            fplayermana:Show()
        else
            fplayerhealth:Hide()
            fplayermana:Hide()
        end
        if GetCVarBool("targetStatusText") then
            ftargethealth:Show()
            ftargetmana:Show()
        else
            ftargethealth:Hide()
            ftargetmana:Hide()
        end
    end
end

---------------------------------------------------
-- EVENTS
---------------------------------------------------
local w = CreateFrame("Frame", nil, UIParent)
w:RegisterEvent("PLAYER_ENTERING_WORLD")
w:RegisterEvent("PLAYER_REGEN_ENABLED")
w:RegisterEvent("PLAYER_TARGET_CHANGED")
w:RegisterEvent("PLAYER_FOCUS_CHANGED")
w:RegisterEvent("CVAR_UPDATE")
if config.classColorParty then
    w:RegisterEvent("PARTY_MEMBERS_CHANGED")
end
function w:OnEvent(event, ...)
    if event == "PLAYER_ENTERING_WORLD" then
        SlashCmdList['RELOAD'] = function() ReloadUI() end
        SLASH_RELOAD1 = '/rl'
        whoa_playerFrame()
        whoa_targetFrame()
        whoa_focusFrame()
        whoa_ufText()
        whoa_cvarUpdate()
    elseif event == "PLAYER_REGEN_ENABLED" then
        whoa_playerFrame()
    elseif event == "PLAYER_TARGET_CHANGED" then
        whoa_targetChange()
    elseif event == "PLAYER_FOCUS_CHANGED" then
        whoa_focusChange()
    elseif event == "CVAR_UPDATE" then
        whoa_cvarUpdate()
    elseif event == "PARTY_MEMBERS_CHANGED" then
        whoa_partyColors()
    end
end
w:SetScript("OnEvent", w.OnEvent)


--[[
	This AddOn is dedicated to one of my friends, and most of the credit goes to Mischback @ WoWInterface, for helping me with the code!
]]

local ADDON_NAME, ns = ... -- Don't touch this.

	-- Little config:
local fontface = "Fonts\\FRIZQT__.TTF" -- The path to the font "Interface\\AddOns\\path to your font.TTF" or Fonts\\FRIZQT__.TTF for default game font
local showalways = false	--[[ Set to true to make the frames movable upon entering the world, set to false to make them unmovable upon entering the world. false is default.
								 The show always thing is mostly for me (Author), as I'm too lazy to type out /ufunlock upon every log in... ]]
local useblizz = false --[[ Set to false to use the default values from this AddOn, instead of Blizzards default position values - Used for when you press the default button.
							Not yet in use!! Will be in next update]]

-- Defaults
local SavedVar = {
	["player"] = {
		["xpos"] = -150,
		["ypos"] = 0,
		["anchor"] = "CENTER",
		["relativePoint"] = "CENTER",
	},
	["target"] = {
		["xpos"] = 150,
		["ypos"] = 0,
		["anchor"] = "CENTER",
		["relativePoint"] = "CENTER",
	},
	["p1"] = {
		["xpos"] = 10,
		["ypos"] = -160,
		["anchor"] = "TOPLEFT",
		["relativePoint"] = "TOPLEFT",
	},
	["p2"] = {
		["xpos"] = 10,
		["ypos"] = -223,
		["anchor"] = "TOPLEFT",
		["relativePoint"] = "TOPLEFT",
	},
	["p3"] = {
		["xpos"] = 10,
		["ypos"] = -286,
		["anchor"] = "TOPLEFT",
		["relativePoint"] = "TOPLEFT",
	},
	["p4"] = {
		["xpos"] = 10,
		["ypos"] = -349,
		["anchor"] = "TOPLEFT",
		["relativePoint"] = "TOPLEFT",
	},
}

-- Functions
	-- Saving the variables to the DB
local function SaveToDB(frame, key) 
	local anchor, relativeTo, relativePoint, xOfs, yOfs = frame:GetPoint()
	Position[key].anchor = anchor
	Position[key].relativePoint = relativePoint
	Position[key].xpos = xOfs
	Position[key].ypos = yOfs
end
	-- Guidanceframes setup
local function MakeItWork(frame)
	frame:SetFont(fontface, 10, "MONOCROME")
	frame:SetInsertMode("TOP")
	frame:SetFading(false)
	frame:SetJustifyH("LEFT")
	frame:SetJustifyV("TOP")
	frame:EnableMouse(true)
end
	
--[[	-- This is for the next update
	-- Reseting to default
local function pdefault()
	if (useblizz == true) then
	PlayerFrame:Setpoint()
	else
	PlayerFrame:SetPoint(SavedVar.player.anchor, UIParent, SavedVar.player.relativepoint, SavedVar.player.xpos, SavedVar.player.ypos)
	end
end
local function tdefault()
	if (useblizz == true) then
	TargetFrame:SetPoint()
	else
	TargetFrame:SetPoint(SavedVar.target.anchor, UIParent, SavedVar.target.relativepoint, SavedVar.target.xpos, SavedVar.target.ypos)
	end
end
local function p1default()
	PartyFrame1:SetPoint(SavedVar.p1.anchor, UIParent, SavedVar.p1.relativepoint, SavedVar.p1.xpos, SavedVar.p1.ypos)
end
local function p2default()
	PartyFrame2:SetPoint(SavedVar.p2.anchor, UIParent, SavedVar.p2.relativepoint, SavedVar.p2.xpos, SavedVar.p2.ypos)
end
local function p3default()
	PartyFrame3:SetPoint(SavedVar.p3.anchor, UIParent, SavedVar.p3.relativepoint, SavedVar.p3.xpos, SavedVar.p3.ypos)
end
local function p4default()
	PartyFrame4:SetPoint(SavedVar.p4.anchor, UIParent, SavedVar.p4.relativepoint, SavedVar.p4.xpos, SavedVar.p4.ypos)
end
]]

	-- Guidance frames
		-- infoframe
local uinfo = CreateFrame("MessageFrame", "uinfo")
uinfo:SetPoint("CENTER", UIParent, "CENTER", 0, 300)
MakeItWork(uinfo)
uinfo:SetSize(250, 100)
uinfo:AddMessage("lock the individual ones.", 1, 0.75, 0, 1)
uinfo:AddMessage("While the buttons on the smaller frames", 1, 0.75, 0, 1)
uinfo:AddMessage("or resets them all.", 1, 0.75, 0, 1)
uinfo:AddMessage("The buttons on this frame locks all frames,", 1, 0.75, 0, 1)
uinfo:AddMessage("To lock them, press one of the buttons.", 1, 0.75, 0, 1)
uinfo:AddMessage("To move the frames, simply drag the squares.", 1, 0.75, 0, 1)
uinfo:AddMessage("The frames are now movable.", 1, 0.75, 0, 1)
uinfo:AddMessage("Zynix Unitframes:", 1, 0.75, 0, 1)

local utex = uinfo:CreateTexture("OVERLAY")
utex:SetAllPoints(uinfo)
utex:SetTexture(0, 0, 0, 0.5)

local ubutton = CreateFrame("Button", "ubutton", uinfo, "UIPanelButtonTemplate")
ubutton:SetWidth(65)
ubutton:SetHeight(20)
ubutton:SetPoint("BOTTOMRIGHT", uinfo, "BOTTOMRIGHT", -1, 1)

local ufont = ubutton:CreateFontString(nil, "OVERLAY")
ufont:SetFont(fontface, 10)
ufont:SetPoint("CENTER", 0, 0)
ufont:SetTextColor(1, 0.75, 0, 1)
ufont:SetText("Lock")

--[[		-- This is also for the next update 
local udbutton = CreateFrame("Button", "udbutton", uinfo, "UIPanelButtonTemplate")
udbutton:SetWidth(65)
udbutton:SetHeight(20)
udbutton:SetPoint("BOTTOMLEFT", uinfo, "BOTTOMLEFT", 1, 1)

local udfont = udbutton:CreateFontString(nil, "OVERLAY")
udfont:SetFont(fontface, 10)
udfont:SetPoint("CENTER", 0, 0)
udfont:SetTextColor(1, 0.75, 0, 1)
udfont:SetText("Reset")
]]

		-- player
local pback = CreateFrame("MessageFrame")
pback:SetPoint("CENTER", PlayerFrame, "CENTER", 0, 0)
pback:SetSize(PlayerFrame:GetSize())
MakeItWork(pback)
pback:AddMessage("Player Frame", 1, 0.75, 0, 1)

local ptex = pback:CreateTexture("OVERLAY")
ptex:SetAllPoints(pback)
ptex:SetTexture(0, 0, 0, 0.5)

local pbutton = CreateFrame("Button", "pbutton", pback, "UIPanelButtonTemplate")
pbutton:SetWidth(65)
pbutton:SetHeight(20)
pbutton:SetPoint("BOTTOMRIGHT", pback, "BOTTOMRIGHT", -1, 1)

local pfont = pbutton:CreateFontString(nil, "OVERLAY")
pfont:SetFont(fontface, 10)
pfont:SetPoint("CENTER", 0, 0)
pfont:SetTextColor(1, 0.75, 0, 1)
pfont:SetText("Lock")

		-- Target
local tback = CreateFrame("MessageFrame")
tback:SetPoint("CENTER", TargetFrame, "CENTER", 0, 0)
tback:SetSize(TargetFrame:GetSize())
MakeItWork(tback)
tback:AddMessage("Target Frame", 1, 0.75, 0, 1)

local ttex = tback:CreateTexture("OVERLAY")
ttex:SetAllPoints(tback)
ttex:SetTexture(0, 0, 0, 0.5)

local tbutton = CreateFrame("Button", "tbutton", tback, "UIPanelButtonTemplate")
tbutton:SetWidth(65)
tbutton:SetHeight(20)
tbutton:SetPoint("BOTTOMRIGHT", tback, "BOTTOMRIGHT", -1, 1)

local tfont = tbutton:CreateFontString(nil, "OVERLAY")
tfont:SetFont(fontface, 10)
tfont:SetPoint("CENTER", 0, 0)
tfont:SetTextColor(1, 0.75, 0, 1)
tfont:SetText("Lock")

		-- Partyframes:
			-- Party1
local p1back = CreateFrame("MessageFrame")
p1back:SetPoint("TOPLEFT", PartyMemberFrame1, "TOPLEFT", 0, 0)
p1back:SetSize(PartyMemberFrame1:GetWidth() + 15, PartyMemberFrame1:GetHeight() + 10)
MakeItWork(p1back)
p1back:AddMessage("Party Frame 1", 1, 0.75, 0, 1)

local p1tex = p1back:CreateTexture("OVERLAY")
p1tex:SetAllPoints(p1back)
p1tex:SetTexture(0, 0, 0, 0.5)

local p1button = CreateFrame("Button", "p1button", p1back, "UIPanelButtonTemplate")
p1button:SetWidth(65)
p1button:SetHeight(20)
p1button:SetPoint("BOTTOMRIGHT", p1back, "BOTTOMRIGHT", -1, 1)

local p1font = p1button:CreateFontString(nil, "OVERLAY")
p1font:SetFont(fontface, 10)
p1font:SetPoint("CENTER", 0, 0)
p1font:SetTextColor(1, 0.75, 0, 1)
p1font:SetText("Lock")

			--Party2
local p2back = CreateFrame("MessageFrame")
p2back:SetPoint("TOPLEFT", PartyMemberFrame2, "TOPLEFT", 0, 0)
p2back:SetSize(PartyMemberFrame2:GetWidth() + 15, PartyMemberFrame2:GetHeight() + 10)
MakeItWork(p2back)
p2back:AddMessage("Party Frame 2", 1, 0.75, 0, 1)

local p2tex = p2back:CreateTexture("OVERLAY")
p2tex:SetAllPoints(p2back)
p2tex:SetTexture(0, 0, 0, 0.5)

local p2button = CreateFrame("Button", "p2button", p2back, "UIPanelButtonTemplate")
p2button:SetWidth(65)
p2button:SetHeight(20)
p2button:SetPoint("BOTTOMRIGHT", p2back, "BOTTOMRIGHT", -1, 1)

local p2font = p2button:CreateFontString(nil, "OVERLAY")
p2font:SetFont(fontface, 10)
p2font:SetPoint("CENTER", 0, 0)
p2font:SetTextColor(1, 0.75, 0, 1)
p2font:SetText("Lock")

			--Party3
local p3back = CreateFrame("MessageFrame")
p3back:SetPoint("TOPLEFT", PartyMemberFrame3, "TOPLEFT", 0, 0)
p3back:SetSize(PartyMemberFrame3:GetWidth() + 15, PartyMemberFrame3:GetHeight() + 10)
MakeItWork(p3back)
p3back:AddMessage("Party Frame 3", 1, 0.75, 0, 1)

local p3tex = p3back:CreateTexture("OVERLAY")
p3tex:SetAllPoints(p3back)
p3tex:SetTexture(0, 0, 0, 0.5)

local p3button = CreateFrame("Button", "p3button", p3back, "UIPanelButtonTemplate")
p3button:SetWidth(65)
p3button:SetHeight(20)
p3button:SetPoint("BOTTOMRIGHT", p3back, "BOTTOMRIGHT", -1, 1)

local p3font = p3button:CreateFontString(nil, "OVERLAY")
p3font:SetFont(fontface, 10)
p3font:SetPoint("CENTER", 0, 0)
p3font:SetTextColor(1, 0.75, 0, 1)
p3font:SetText("Lock")

			--Party4
local p4back = CreateFrame("MessageFrame")
p4back:SetPoint("TOPLEFT", PartyMemberFrame4, "TOPLEFT", 0, 0)
p4back:SetSize(PartyMemberFrame4:GetWidth() + 15, PartyMemberFrame4:GetHeight() + 10)
MakeItWork(p4back)
p4back:AddMessage("Party Frame 4", 1, 0.75, 0, 1)

local p4tex = p4back:CreateTexture("OVERLAY")
p4tex:SetAllPoints(p4back)
p4tex:SetTexture(0, 0, 0, 0.5)

local p4button = CreateFrame("Button", "p4button", p4back, "UIPanelButtonTemplate")
p4button:SetWidth(65)
p4button:SetHeight(20)
p4button:SetPoint("BOTTOMRIGHT", p4back, "BOTTOMRIGHT", -1, 1)

local p4font = p4button:CreateFontString(nil, "OVERLAY")
p4font:SetFont(fontface, 10)
p4font:SetPoint("CENTER", 0, 0)
p4font:SetTextColor(1, 0.75, 0, 1)
p4font:SetText("Lock")
	-- Guidance Frames end

	-- Creating a frame for the initialization of the AddOn, and the moving of the frames
local init = CreateFrame("Frame")
init:RegisterEvent("ADDON_LOADED")
init:SetScript("OnEvent", function(self, event, addon)
	if ( addon ~= ADDON_NAME ) then return end		-- jump out, if it's not our addon
	local k, v
	
	-- If everything is as it should be, then do this
	PlayerFrame:SetMovable(false)
	TargetFrame:SetMovable(false)
	PartyMemberFrame1:SetMovable(false)
	PartyMemberFrame2:SetMovable(false)
	PartyMemberFrame3:SetMovable(false)
	PartyMemberFrame4:SetMovable(false)
	if showalways then
		pback:Show()
		tback:Show()
		uinfo:Show()
		p1back:Show()
		p2back:Show()
		p3back:Show()
		p4back:Show()
		PlayerFrame:SetMovable(true)
		TargetFrame:SetMovable(true)
		PartyMemberFrame1:SetMovable(true)
		PartyMemberFrame2:SetMovable(true)
		PartyMemberFrame3:SetMovable(true)
		PartyMemberFrame4:SetMovable(true)
	else
		pback:Hide()
		p1back:Hide()
		p2back:Hide()
		p3back:Hide()
		p4back:Hide()
		tback:Hide()
		uinfo:Hide()
	end
	
	-- First startup
	if not Position then
		Position = {}
		PlayerFrame:SetMovable(true)
		TargetFrame:SetMovable(true)
		PartyMemberFrame1:SetMovable(true)
		PartyMemberFrame2:SetMovable(true)
		PartyMemberFrame3:SetMovable(true)
		PartyMemberFrame4:SetMovable(true)
		PartyMemberFrame1:SetUserPlaced(false)
		PartyMemberFrame2:SetUserPlaced(false)
		PartyMemberFrame3:SetUserPlaced(false)
		PartyMemberFrame4:SetUserPlaced(false)
		pback:Show()
		tback:Show()
		p1back:Show()
		p2back:Show()
		p3back:Show()
		p4back:Show()
		uinfo:Show()
	end
	
	for k, v in pairs(SavedVar) do
		if type(v) ~= type(Position[k]) then
			Position[k] = v
		end
	end
	
	-- Finally through
	PlayerFrame:ClearAllPoints()
	PlayerFrame:SetPoint(Position.player.anchor, UIParent, Position.player.relativePoint, Position.player.xpos, Position.player.ypos)
	SaveToDB(PlayerFrame, "player") 
	TargetFrame:ClearAllPoints()
	TargetFrame:SetPoint(Position.target.anchor, UIParent, Position.target.relativePoint, Position.target.xpos, Position.target.ypos)
	SaveToDB(TargetFrame, "target")
	PartyMemberFrame1:ClearAllPoints()
	PartyMemberFrame1:SetPoint(Position.p1.anchor, UIParent, Position.p1.relativePoint, Position.p1.xpos, Position.p1.ypos)
	SaveToDB(PartyMemberFrame1, "p1")
	PartyMemberFrame2:ClearAllPoints()
	PartyMemberFrame2:SetPoint(Position.p2.anchor, UIParent, Position.p2.relativePoint, Position.p2.xpos, Position.p2.ypos)
	SaveToDB(PartyMemberFrame2, "p2")
	PartyMemberFrame3:ClearAllPoints()
	PartyMemberFrame3:SetPoint(Position.p3.anchor, UIParent, Position.p3.relativePoint, Position.p3.xpos, Position.p3.ypos)
	SaveToDB(PartyMemberFrame3, "p3")
	PartyMemberFrame4:ClearAllPoints()
	PartyMemberFrame4:SetPoint(Position.p4.anchor, UIParent, Position.p4.relativePoint, Position.p4.xpos, Position.p4.ypos)
	SaveToDB(PartyMemberFrame4, "p4")
	PlayerFrame.SetPoint = function() end
end)
	-- Slashcommands:
		-- unlocking the frame
SLASH_UNLOCK1 = "/zui"
SlashCmdList["UNLOCK"] = function()
	PlayerFrame:SetMovable(true)
	TargetFrame:SetMovable(true)
	PartyMemberFrame1:SetMovable(true)
	PartyMemberFrame2:SetMovable(true)
	PartyMemberFrame3:SetMovable(true)
	PartyMemberFrame4:SetMovable(true)
	pback:Show()
	tback:Show()
	p1back:Show()
	p2back:Show()
	p3back:Show()
	p4back:Show()
	uinfo:Show()
end

		-- Author help
--[[ Developer tool
SLASH_FRAMENAME1 = "/frame"
SlashCmdList["FRAMENAME"] = function() 
	local anchor, relativeTo, relativePoint, xOfs, yOfs = GetMouseFocus():GetPoint()
	local name = GetMouseFocus():GetName()
	local width, height = GetMouseFocus():GetSize()
	DEFAULT_CHAT_FRAME:AddMessage("|cffffd700Zynix UnitFrames Info:|r")
	DEFAULT_CHAT_FRAME:AddMessage("|cffffd700Position: |r"..anchor.." / "..relativeTo:GetName().." / "..relativePoint.." / "..xOfs.." / "..yOfs.."")
	DEFAULT_CHAT_FRAME:AddMessage("|cffffd700Width: |r"..width.."")
	DEFAULT_CHAT_FRAME:AddMessage("|cffffd700Height: |r"..height.."")
	if (GetMouseFocus():GetName() == nil) then return 
	else
	DEFAULT_CHAT_FRAME:AddMessage("|cffffd700Name: |r"..name.."")
	end
end
]]	-- Slashcommands end
	
	-- Scripts:
		-- locking the frame(s)
			-- Player
pbutton:SetScript("OnClick", function()	
	pback:Hide()
	PlayerFrame:SetMovable(false)
	if (tback:IsShown()==nil) and (p1back:IsShown()==nil) and (p2back:IsShown()==nil) and (p3back:IsShown()==nil) and (p4back:IsShown()==nil) then
	uinfo:Hide()
	end
end)

			-- Target
tbutton:SetScript("OnClick", function()
	tback:Hide()
	TargetFrame:SetMovable(false)
	if (pback:IsShown()==nil) and (p1back:IsShown()==nil) and (p2back:IsShown()==nil) and (p3back:IsShown()==nil) and (p4back:IsShown()==nil) then
	uinfo:Hide()
	end
end)

			-- Party1
p1button:SetScript("OnClick", function()	
	p1back:Hide()
	PartyMemberFrame1:SetMovable(false)
	if (pback:IsShown()==nil) and (tback:IsShown()==nil) and (p2back:IsShown()==nil) and (p3back:IsShown()==nil) and (p4back:IsShown()==nil) then
	uinfo:Hide()
	end
end)

			-- Party2
p2button:SetScript("OnClick", function()	
	p2back:Hide()
	PartyMemberFrame2:SetMovable(false)
	if (pback:IsShown()==nil) and (p1back:IsShown()==nil) and (tback:IsShown()==nil) and (p3back:IsShown()==nil) and (p4back:IsShown()==nil) then
	uinfo:Hide()
	end
end)

			-- Party3
p3button:SetScript("OnClick", function()	
	p3back:Hide()
	PartyMemberFrame3:SetMovable(false)
	if (pback:IsShown()==nil) and (p1back:IsShown()==nil) and (p2back:IsShown()==nil) and (tback:IsShown()==nil) and (p4back:IsShown()==nil) then
	uinfo:Hide()
	end
end)

			-- Party4
p4button:SetScript("OnClick", function()	
	p4back:Hide()
	PartyMemberFrame4:SetMovable(false)
	if (pback:IsShown()==nil) and (p1back:IsShown()==nil) and (p2back:IsShown()==nil) and (p3back:IsShown()==nil) and (tback:IsShown()==nil) then
	uinfo:Hide()
	end
end)
			-- Infoframe
ubutton:SetScript("OnClick", function()
	PlayerFrame:SetMovable(false)
	TargetFrame:SetMovable(false)
	PartyMemberFrame1:SetMovable(true)
	PartyMemberFrame2:SetMovable(true)
	PartyMemberFrame3:SetMovable(true)
	PartyMemberFrame4:SetMovable(true)
	pback:Hide()
	tback:Hide()
	uinfo:Hide()
	p1back:Hide()
	p2back:Hide()
	p3back:Hide()
	p4back:Hide()
end)
		-- Locking scripts end

--[[ 		-- this is for the next update
		-- Default scripts
udbutton:SetScript("OnClick", pdefault) 
]]

		-- The actual moving, stopping and saving
			-- Player
pback:SetScript("OnMouseDown", function()
	if PlayerFrame:IsMovable() == 1 then
		PlayerFrame:StartMoving()
	else PlayerFrame:StopMovingOrSizing()
	end
end)

pback:SetScript("OnMouseUp", function()
	PlayerFrame:StopMovingOrSizing()
	SaveToDB(PlayerFrame, "player")
end)

			-- Target
tback:SetScript("OnMouseDown", function()
	if TargetFrame:IsMovable() == 1 then
		TargetFrame:StartMoving()
	else TargetFrame:StopMovingOrSizing()
	end
end)

tback:SetScript("OnMouseUp", function()
	TargetFrame:StopMovingOrSizing()
	SaveToDB(TargetFrame, "target")
end)

			-- Party1
p1back:SetScript("OnMouseDown", function()
	if PartyMemberFrame1:IsMovable() == 1 then
		PartyMemberFrame1:StartMoving()
	else PartyMemberFrame1:StopMovingOrSizing()
	end
end)

p1back:SetScript("OnMouseUp", function()
	PartyMemberFrame1:StopMovingOrSizing()
	SaveToDB(PartyMemberFrame1, "p1")
end)

			-- Party2
p2back:SetScript("OnMouseDown", function()
	if PartyMemberFrame2:IsMovable() == 1 then
		PartyMemberFrame2:StartMoving()
	else PartyMemberFrame2:StopMovingOrSizing()
	end
end)

p2back:SetScript("OnMouseUp", function()
	PartyMemberFrame2:StopMovingOrSizing()
	SaveToDB(PartyMemberFrame2, "p2")
end)
			
			-- Party3
p3back:SetScript("OnMouseDown", function()
	if PartyMemberFrame3:IsMovable() == 1 then
		PartyMemberFrame3:StartMoving()
	else PartyMemberFrame3:StopMovingOrSizing()
	end
end)

p3back:SetScript("OnMouseUp", function()
	PartyMemberFrame3:StopMovingOrSizing()
	SaveToDB(PartyMemberFrame3, "p3")
end)

			-- Party4
p4back:SetScript("OnMouseDown", function()
	if PartyMemberFrame4:IsMovable() == 1 then
		PartyMemberFrame4:StartMoving()
	else PartyMemberFrame4:StopMovingOrSizing()
	end
end)

p4back:SetScript("OnMouseUp", function()
	PartyMemberFrame4:StopMovingOrSizing()
	SaveToDB(PartyMemberFrame4, "p4")
end)
FocusFrame:ClearAllPoints()
FocusFrame:SetPoint("LEFT", UIParent, "LEFT", -5, 0)